./cd-lock /dev/cdrom
if [ $? -ne 0 ]
then
 echo "Failed NO CD"
 exit -1
fi

mkdir -p /tmp/settings
mkdir -p /tmp/settings/settings
rm -f /tmp/settings/settings/*
cp tmp/xml/*.xml /tmp/settings/settings

RESULT=`./getMSInfo.sh`
if [ $? -ne 0 ]
then
 echo "Failed to get MSInfo damaged CD"
 ./cd-unlock /dev/cdrom
 exit -1
fi

if test -z "$RESULT"
then
   echo "First Session" 
   mkisofs -o /tmp/settings.iso -R -v /tmp/settings > tmp/ttt 2>&1
else
   echo "Nth Session"
   mkisofs -o /tmp/settings.iso -R -v -C $RESULT -M /dev/hdb /tmp/settings > tmp/ttt 2>&1
fi
   cdrecord -dd -multi driveropts=burnfree dev=/dev/hdb gracetime=2 /tmp/settings.iso >> tmp/ttt 2>&1

if [ $? -eq 0 ] # Test success of command
then
   echo "cdrecord succeeded"
   cdrecord -eject dev=/dev/hdb
   cdrecord -load dev=/dev/hdb
   rm -f /tmp/settings/settings/*
   rm /tmp/settings.iso
   exit 0
else
   echo "cd record failed!"
   ./cd-unlock /dev/cdrom
   rm -f /tmp/settings/settings/*
   rm /tmp/settings.iso
   exit -1
fi


