# Run cdrecord to get the session info..
# but time it out if its taking too long
# as it hangs on a damaged CD

RESULT=`./getMSInfo.sh`
if [ $? -ne 0 ]
then
 echo "Failed to get MSInfo damaged CD"
 exit -1
fi

if test -z "$RESULT"
then
   echo "First Session" > tmp/ttt 
   nice ./mkisofs -o /var/archiver/cd.iso -R -v -graft-points -path-list /var/archiver/cdimage/CDPathList >> tmp/ttt 2>&1
else
   echo "Second Session" > tmp/ttt
   nice ./mkisofs -o /var/archiver/cd.iso -R -v -C $RESULT -M /dev/hdb -graft-points -path-list /var/archiver/cdimage/CDPathList >> tmp/ttt 2>&1
fi
echo "Doing Burn"
nice -n 1 cdrecord -dd -multi driveropts=burnfree dev=/dev/hdb gracetime=2 /var/archiver/cd.iso >> tmp/ttt 2>&1
if [ $? -eq 0 ] # Test success of command
then
   echo "cdrecord succeeded"
   cdrecord -eject dev=/dev/hdb
   cdrecord -load dev=/dev/hdb
   ./cd-lock /dev/cdrom
   exit 0
else
   echo "cd record failed!"
   exit -1
fi

