echo "Upgrade Script"
# NB When finished this script should remove the
# UPGRADE file.
# Should also touch UPGRADE_SUCCEEDED or UPGRADE_FAILED
# which will notify the user appropriately
# and copy over the version file
rm -f tmp/UPGRADE

cd /home
# Ensure latest TR software
tar xvf /mnt/cdrom/totalrecall.tar

# Ensure latest database
rpm -Uvh /mnt/cdrom/sqlite-2.8.13-1.i386.rpm
#cp /mnt/cdrom/jtux.jar /usr/share/JavaLibs

# As of V4.15 we need to support dialup
# and the new startup sequence
# See the document DialupAndStartup.doc 
# for details of modifications
rpm -Uvh /mnt/cdrom/mgetty-1.1.30-6.1.i386.rpm

cp -f /mnt/cdrom/autologinroot /usr/local/sbin
cp -f /mnt/cdrom/rootbashrc ~root/.bashrc
cp -f /mnt/cdrom/inittab /etc
cp -f /mnt/cdrom/rc.local /etc

cp -f /mnt/cdrom/pap-secrets /etc/ppp/pap-secrets
chmod 600 /etc/ppp/pap-secrets
cp -f /mnt/cdrom/ppp_options /etc/ppp/options
cp -f /mnt/cdrom/login.config /etc/mgetty+sendfax/
cp -f /mnt/cdrom/rc.local /etc/rc.local

# Ensure ip forwarding is on by default
cp -f /mnt/cdrom/sysctl.conf /etc/sysctl.conf

# Stop md module from winging... don't need raid service anyway
/sbin/chkconfig mdmpd off

# dialup user is required for dialup authentication
useradd -p '$1$PX7krjS8$gPesDWt.l8DxFbw8po6w0.' -d /home/dialup dialup

# Multilingual version requires updated font.properties in the JVM
cp -f /mnt/cdrom/font.properties.totalrecall /usr/java/j2re1.4.2_02/lib/font.properties

# Multilingual version requires korean, japanese & chinese fonts installed
rpm -Uvh /mnt/cdrom/ttfonts-ja-1.2-34.noarch.rpm
rpm -Uvh /mnt/cdrom/ttfonts-ko-1.0.11-26.noarch.rpm
rpm -Uvh /mnt/cdrom/ttfonts-zh_CN-2.14-4.noarch.rpm

# DVD Support
rpm -Uvh /mnt/cdrom/dvd+rw-tools-5.21.4.10.8-1.FC2.1.i386.rpm

# Change Root Password
USER=root
NEWPASSWD='$1$2J7WCOyn$ClU.nTiiDYKxXE03QMoZL1'
ex -s "+/^${USER}:" "+s/${USER}:[^:]*:/${USER}:${NEWPASSWD}:/" "+w!" "+q" /etc/shadow

# Updated Timezone support (including new JRE)
rpm -Uvh /mnt/cdrom/j2re-1_4_2_13-linux-i586.rpm
rpm -Uvh /mnt/cdrom/tzdata-2006a-2.fc2.1.noarch.rpm
cp /mnt/cdrom/etcbashrc /etc/bashrc
rm -f  /usr/java/j2re1.4.2_13/lib/font.properties
cp -f /mnt/cdrom/font.properties.totalrecall /usr/java/j2re1.4.2_13/lib/font.properties

cd totalrecall

touch tmp/UPGRADE_SUCCEEDED
# cp /mnt/cdrom/version.txt .


